"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _jquery = _interopRequireDefault(require("jquery"));
var _stringUtils = _interopRequireDefault(require("./utils/stringUtils"));
var _objectUtils = _interopRequireDefault(require("./utils/objectUtils"));
var _startsWith = _interopRequireDefault(require("babel-runtime/core-js/string/starts-with"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function add(container, root, selector, name) {
  var itemName = _stringUtils.default.toCamelCase(name, "-", "");
  var $itemName = '$' + itemName;
  var $element;
  if (root && root.is(selector)) {
    $element = root;
  } else {
    $element = root ? root.find(selector) : (0, _jquery.default)(selector);
  }

  //console.log("Setting: " + $itemName);
  container[$itemName] = $element;
  if ($element.length > 0) {
    //console.log("Setting: " + itemName);
    container[itemName] = $element.get(0);
  }
}
function nameFromSelector(selector) {
  var name;
  if ((0, _startsWith.default)(selector, '#') || (0, _startsWith.default)(selector, '.')) {
    name = selector.substring(1, selector.length);
  } else {
    name = selector;
  }
  return name;
}

/* 
 * An object that contains the element and jquery items for each item in items.
 * items contains the jqery selector and name. It can be an array of strings
 * where the name is made by removing either the '.' or '#' form the string.
 * ["panel", "#list"]
 *
 * If the array item is an array the first item is the name and the second
 * is the selector. 
 * [["panel", "#panel"], ["list", "#item-list"]]
 *
 * If the array item is an object, the name and selector is taken from 
 * item.name and item.selector. 
 * [{name:"panel", selector:"#panel"}, {name:"list", selector:"#item-list"}]
 *
 * The jqery object name is name with $ prepeneded to it. Names with '-'
 * get the '-' removed and the alpha character following '-' is set to upper case
 * the-name becomes theName and the jquery object become $theName.
 */
var ElementSet = exports.default = /*#__PURE__*/_createClass(function ElementSet(root, items) {
  _classCallCheck(this, ElementSet);
  var max = items.length;
  for (var i = 0; i < max; i++) {
    var item = items[i];
    var selector;
    var name;
    if (typeof item === 'string') {
      selector = item;
      name = nameFromSelector(selector);
    } else if (_objectUtils.default.isPlainObject(item)) {
      selector = item.selector;
      name = item.name;
    } else if (_objectUtils.default.isArrayLike(item)) {
      if (item.length > 1) {
        selector = item[0];
        name = item[1];
      } else if (item.length > 0) {
        selector = item[0];
        name = nameFromSelector(selector);
      }
    }
    if (typeof name !== 'undefined' && typeof selector !== 'undefined') {
      add(this, root, selector, name);
    }
  }
});