"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
/*
    JSS processor Version 1.0.1
    from: http://jss-lang.org/

	Copyright (c) 2011 Wolfgang Schmidetzki
	
	Permission is hereby granted, free of charge, to any person obtaining a copy 
	of this software and associated documentation files (the "Software"), 
	to deal in the Software without restriction, including without limitation the rights to use, 
	copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, 
	and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
	
	The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
	
	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
	INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. 
	IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
	DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
	ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

	Objects are converted to css

	".thing-fish" {
		"color": "#fff",
		"background-color": "#000"
	}

	"top,left,right": 10 =>

	top: 10px;
	left: 10px;
	right: 10px;

	NESTED:

	a: {
		".selected": {
			color: "blue"
		}
	}	

	=> 

	a .selected{
		color: blue;
	}

	NESTED &

  a: {
		"&.selected": {
			color: "red"
		}
	}

	=>

	a.selected {
		color: red;
	}

  Properties ending with _ or - and objects as value 

  background_: {
		color: "red",
		image: "url(...)"
	}

	=>

	background-color: red;
	background-image: url(...);

	Numbers are assumed to be pixels.

	padding: 5 => padding: 5px;

	Arrays:

	background_image: [
		"-moz-linear-gradient(white, gray)",
		"-webkit-linear-gradient(white, gray)"
	]

	=>

	background-image: -moz-linear-gradient(white, gray);
	background-image: -webkit-linear-gradient(white, gray);

	@font-face is preserved

	"@font-face": [
		{
			"font-family":"MyFont",
			"src":"url('//...')"
		},
		{
			"font-family":"MyFont2",
			"src":[
				"url('//...')",
				"url('//...') format('eot'),url('//...') format('woff'),url('/font/futura-400-normal.ttf') format('truetype'),url('/font/futura-400-normal.svg#90849783-61a3-41a1-928c-0e77e65fe53c') format('svg')"
			]
		}
	]

	=>

	@font-face {
		font-family:MyFont;
		src:url('//...');
	}

	@font-face {
		font-family:MyFont2;
		src:url('//...');
		src: url('//...') format('eot'),url('//...') format('woff'),url('/font/futura-400-normal.ttf') format('truetype'),url('/font/futura-400-normal.svg#90849783-61a3-41a1-928c-0e77e65fe53c') format('svg');
	}

*/

function _default() {
  function addVars(vars) {
    for (var i in vars) this[i] = vars[i];
  }
  function addVar(property, value) {
    this[property] = value;
  }
  function toCSS(jss, scope) {
    var result = {};
    if (typeof jss == "string") {
      // evaluate the JSS object:	
      try {
        eval("var jss = {" + jss + "}");
      } catch (e) {
        console.warn(e);
        return "/*\nUnable to parse JSS: " + e + "\n*/";
      }
    }
    json_to_css(scope || "", jss);

    // output result:	
    var ret = "";
    for (var a in result) {
      var css = result[a];
      if (Object.keys(css).length > 0) {
        if (a == '@font-face') {
          ret += output_font_face(a, css);
        } else {
          ret += output_syle(a, css);
        }
      }
    }
    return ret;

    // a: css([{gerg:ege src:[eheh, ergeg]}), ]
    function output_font_face(a, css) {
      var ret = '';
      for (var i = 0, max = css.length; i < max; i++) {
        var values = css[i];
        ret += a + " {\n";
        for (var attr in values) {
          var val = values[attr];
          if (Array.isArray(val)) {
            for (var n = 0; n < val.length; n++) {
              ret += "\t" + attr + ": " + val[n] + ";\n";
            }
          } else {
            ret += "\t" + attr + ": " + val + ";\n";
          }
        }
        ret += "}\n";
      }
      return ret;
    }
    function output_syle(a, css) {
      var ret = '';
      ret = a + " {\n";
      for (var i in css) {
        var values = css[i]; // this is an array !
        for (var j = 0; j < values.length; j++) ret += "\t" + i + ": " + values[j] + ";\n";
      }
      ret += "}\n";
      return ret;
    }

    // --------------	

    function json_to_css(scope, css) {
      if (scope && !result[scope]) result[scope] = {};
      for (var property in css) {
        var value = css[property];
        if (property === '@font-face') {
          font_face_to_css(value);
        } else if (value instanceof Array) {
          var values = value;
          for (var i = 0; i < values.length; i++) addProperty(scope, property, values[i]);
        } else switch (_typeof(value)) {
          case "number":
          case "string":
            addProperty(scope, property, value);
            break;
          case "object":
            var endChar = property.charAt(property.length - 1);
            if (scope && (endChar == "_" || endChar == "-")) {
              var variants = value;
              for (var ii in variants) {
                // i may be a comma separted list
                var list = ii.split(/\s*,\s*/);
                for (var j = 0; j < list.length; j++) {
                  var value2 = variants[ii];
                  if (value2 instanceof Array) {
                    var values2 = value2;
                    for (var k = 0; k < values2.length; k++) addProperty(scope, property + list[j], values2[k]);
                  } else addProperty(scope, property + list[j], variants[ii]);
                }
              }
            } else json_to_css(makeSelectorName(scope, property), value);
            break;
          default:
            console.warn("ignoring unknown type " + _typeof(value) + " in property " + property);
        }
      }
    }
    function font_face_to_css(value) {
      var scope = '@font-face',
        values;
      if (value == undefined) return;
      if (!Array.isArray(value)) values = [value];else values = value;
      for (var i = 0, max = values.length; i < max; i++) {
        var nface = {},
          face = values[i];
        for (var prop in face) {
          var nval = face[prop];
          if (typeof nval == "number") nval = nval + "px";
          nface[prop] = nval;
        }
        if (result[scope]) result[scope].push(nface);else result[scope] = [nface];
      }
    }
    function makePropertyName(n) {
      return n.replace(/_/g, "-");
    }
    function makeSelectorName(scope, name) {
      var snames = [];
      var names = name.split(/\s*,\s*/);
      var scopes = scope.split(/\s*,\s*/);
      for (var s = 0; s < scopes.length; s++) {
        var scope2 = scopes[s];
        for (var i = 0; i < names.length; i++) {
          var name2 = names[i];
          if (name2.charAt(0) == "&") snames.push(scope2 + name2.substr(1));else snames.push(scope2 ? scope2 + " " + name2 : name2);
        }
      }
      return snames.join(", ");
    }
    function addProperty(scope, property, value) {
      if (typeof value == "number") value = value + "px";
      var properties = property.split(/\s*,\s*/);
      for (var i = 0; i < properties.length; i++) {
        var property2 = makePropertyName(properties[i]);
        if (result[scope][property2]) {
          result[scope][property2].push(value);
        } else {
          result[scope][property2] = Array.isArray(value) ? value : [value];
        }
      }
    }
  }

  /*
  * JSS.linearGradient([point,] color [,color] ... [,color])
  * 
  * This function returns an array of gradient values for webkit and mozilla.
  * 
  * Sample:
  * 
  * JSS.linearGradient("silver 40%", "gray")
  * returns:
  * 
  * [
  *   "-moz-linear-gradient(silver 40%, gray)",
  *   "-webkit-linear-gradient(silver 40%, gray)"
  * ]
  * Sample usage:
  * 
  * background_image: JSS.linearGradeint("silver 40%", "gray")
  */
  function linearGradient() {
    var args = [];
    for (var i = 0; i < arguments.length; i++) args.push(arguments[i]);
    args = args.join(",");
    return ["-moz-linear-gradient(" + args + ")", "-webkit-linear-gradient(" + args + ")"];
  }

  /*
   * This function takes a color either as string in format (#)RRGGBB or 
   * as array [r,g,b] with RGB values. It then multiplies the single values 
   * for red, green and blue with the factor and returns the result as 
   * String in format #RRGGBB. If factor is omitted factor 1 is used.
   *
   * Sample:
   *
   * JSS.color("#ffc800", .9)
   * returns "#e5b400".
   */
  function color(color, factor) {
    // color is either a string in format (#)rrggbb or an array [r,g,b]
    var f = factor == undefined ? 1 : factor;
    var r, g, b;
    if (typeof color == "string") {
      if (color.charAt(0) == "#") color = color.substr(1);
      r = Number("0x" + color.substr(0, 2));
      g = Number("0x" + color.substr(2, 2));
      b = Number("0x" + color.substr(4, 2));
    } else if (color) {
      r = color[0];
      g = color[1];
      b = color[2];
    } else r = g = b = 0;
    r = cut(r * f);
    g = cut(g * f);
    b = cut(b * f);
    function cut(v) {
      return parseInt(Math.max(Math.min(255, v), 0));
    }
    return toHex(r, g, b);
  }

  /*
   * Converts r, g, b to hex.
   */
  function toHex(r, g, b) {
    var ret = (r * 256 * 256 + g * 256 + b).toString(16);
    while (ret.length < 6) ret = "0" + ret;
    return "#" + ret;
  }

  // public interface:
  return {
    toCSS: toCSS,
    addVars: addVars,
    addVar: addVar,
    linearGradient: linearGradient,
    color: color,
    toHex: toHex
  };
}