"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _objectUtils = _interopRequireDefault(require("./utils/objectUtils"));
var _stringUtils = _interopRequireDefault(require("./utils/stringUtils"));
var _startsWith = _interopRequireDefault(require("babel-runtime/core-js/string/starts-with"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Handles communication between windows
 */
var Messenger = exports.default = /*#__PURE__*/function () {
  /*
   * _window is the window to listen on.
   * targetWindow is the window to communicate with.
   * targetOorigin is the origin url of the target.
   */
  function Messenger(_window, targetWindow, targetOrigin) {
    _classCallCheck(this, Messenger);
    this.window = _window || window;
    this._onHandleMessage = this._onHandleMessage.bind(this);
    this.targetOrigin = targetOrigin || '*';
    this.onMessengerHandler = null;
    this.targetWindow = targetWindow || null;
    this.userData = null;
    this.prefix = "";
    this.nextId = 0;
    this.name = 'messenger';
  }

  /*
   * Handles a message form another window.
   */
  _createClass(Messenger, [{
    key: "_onHandleMessage",
    value: function _onHandleMessage(event) {
      if (_objectUtils.default.isString(event.data) == false || this.prefix && !(0, _startsWith.default)(event.data, this.prefix)) {
        return;
      }
      var json = this.prefix ? event.data.substring(this.prefix.length) : event.data;

      //console.log('Message Received ' + this.name + ': ' + window.location + ' raw json: ' + json);

      var data = JSON.parse(json);
      if (data.type) {
        var name = 'on' + _stringUtils.default.toCamelCase(data.type, '_', '', true);
        if (this.onMessengerHandler && name in this.onMessengerHandler && typeof this.onMessengerHandler[name] === 'function') {
          this.onMessengerHandler[name](this, event, data);
        }
      }
    }
  }, {
    key: "_postMessage",
    value: function _postMessage(message) {
      if (this.targetWindow && this.targetWindow.postMessage && this.targetOrigin) {
        var messageString = this.prefix + JSON.stringify(message);
        //console.log('Message sent ' + this.name + ': ' + window.location + ' origin: ' + this.targetOrigin + ' message: ' + messageString);

        this.targetWindow.postMessage(messageString, this.targetOrigin);
      }
    }
  }, {
    key: "postMessage",
    value: function postMessage(type, data) {
      var message = _objectUtils.default.extend({}, data);
      message.type = type;
      message.messageid = (this.name || 'messenger') + '-' + this.nextId++;
      this._postMessage(message);
    }
  }, {
    key: "setName",
    value: function setName(name) {
      this.name = name;
    }

    /* 
     * The prefix allows a tag to be added as a prefix to a sent message. Upon 
     * receiving the message the message is checked to ensure the message starts 
     * with prefix. Prefix is stripped before parsing the message a json. This 
     * ensures that we only parse the proper messages.
     */
  }, {
    key: "setPrefix",
    value: function setPrefix(prefix) {
      this.prefix = prefix;
    }
  }, {
    key: "setUserData",
    value: function setUserData(udata) {
      this.userData = udata;
    }
  }, {
    key: "getUserData",
    value: function getUserData() {
      return this.userData;
    }
  }, {
    key: "startListening",
    value: function startListening() {
      this.window.addEventListener('message', this._onHandleMessage, false);
    }
  }, {
    key: "stopListening",
    value: function stopListening() {
      this.window.removeEventListener('message', this._onHandleMessage, false);
    }
  }, {
    key: "setTargetOrigin",
    value: function setTargetOrigin(url) {
      this.targetOrigin = url;
    }
  }]);
  return Messenger;
}();