"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/*
 * Pointer Events Polyfill: Adds support for the style attribute "pointer-events: none" to browsers without this feature (namely, IE).
 * (c) 2013, Kent Mewhort, licensed under BSD. See LICENSE.txt for details.
 */

var PointerEventsPolyfill;
(function () {
  // Prevents a drunk to use it twice
  if (!PointerEventsPolyfill) {
    var attachedOnce = false;
    var addEventListenerMethod = document.addEventListener ? 'addEventListener' : 'attachEvent';

    // Handle multiple events with same callback. Works with ms.
    var attachEvents = function attachEvents(elem, events, callback) {
      for (var i = 0; i < events.length; i++) {
        elem[addEventListenerMethod](events[i], callback);
      }
    };

    // Detects if pointer-events is supported
    var hasNativePointerEventsSupport = function hasNativePointerEventsSupport() {
      var element = document.createElement('span');
      element.style.cssText = 'pointer-events:auto';
      return element.style.pointerEvents === 'auto';
    };

    // Cross browser `window.getComputedStyle`, taken from jquery .css() source
    /*
    var getElemComputedStyle = function(elem) {
      if ( elem.ownerDocument.defaultView.opener ) {
        return elem.ownerDocument.defaultView.getComputedStyle( elem, null );
      }
      return window.getComputedStyle( elem, null );
    };
    */
    var polyfillCallback = function polyfillCallback(e) {
      if (e.target.style.pointerEvents === 'none') {
        var origDisplayAttribute = e.target.style.display;
        e.target.style.display = 'none';
        var underneathElem = document.elementFromPoint(e.clientX, e.clientY);
        e.target.style.display = origDisplayAttribute;
        e.target = underneathElem;
        if (underneathElem.dispatchEvent) {
          underneathElem.dispatchEvent(e);
        } else if (underneathElem.fireEvent) {
          underneathElem.fireEvent('on' + e.eventType, e);
        }
        return false;
      } else {
        return true;
      }
    };
    PointerEventsPolyfill = {};
    PointerEventsPolyfill.attach = function (userOptions) {
      userOptions = userOptions || {};
      var options = {
        mouseEvents: userOptions.mouseEvents || ['click', 'dblclick', 'mousedown', 'mouseup'],
        usePolyfillIf: userOptions.usePolyfillIf || function () {
          return !hasNativePointerEventsSupport();
        }
      };
      if (attachedOnce || !options.usePolyfillIf()) {
        return false;
      } else {
        attachedOnce = true;
        attachEvents(document, userOptions.mouseEvents, polyfillCallback);
        return true;
      }
    };
    PointerEventsPolyfill.initialize = PointerEventsPolyfill.attach;
    window.PointerEventsPolyfill = PointerEventsPolyfill;
  }
})();
var _default = exports.default = PointerEventsPolyfill;