"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _objectUtils = _interopRequireDefault(require("./objectUtils"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var CookieUtils = /*#__PURE__*/function () {
  function CookieUtils() {
    _classCallCheck(this, CookieUtils);
  }
  _createClass(CookieUtils, [{
    key: "getAll",
    value: function getAll() {
      if (typeof this._all === 'undefined') {
        var cookies = document.cookie.split(';');
        var ret = {};
        for (var i = 0; i < cookies.length; i++) {
          var cookie = cookies[i].split('=');
          var key = cookie && cookie.length > 0 ? cookie[0].trim() : undefined;
          var value = cookie && cookie.length > 1 ? cookie[1] : undefined;
          if (key && typeof value !== 'undefined') {
            ret[key] = value;
          }
        }
        this._all = ret;
      }
      return this._all;
    }
  }, {
    key: "has",
    value: function has(name) {
      return typeof this.getAll()[name] !== 'undefined';
    }
  }, {
    key: "get",
    value: function get(name) {
      return this.getAll()[name];
    }

    /*
     * gets a cookie and parses the json.
     * name - the name of the cookie.
     */
  }, {
    key: "getObject",
    value: function getObject(name) {
      var value = this.get(name);
      var ret = undefined;
      if (typeof value !== "undefined") {
        try {
          ret = JSON.parse(value);
        } catch (e) {
          console.warn(e);
        }
      }
      return ret;
    }

    /*
     * name - cookie name.
     * value - cookie value.
     * data {
     *    expires (optional) - expiration in seconds from now or Date of expire.
     *    path (optional) - path for the cookie
     *    domain
     *    secure
     * }
     */
  }, {
    key: "set",
    value: function set(name, value, data) {
      var d = new Date();
      var expires;
      var path;
      var secure;
      var domain;
      data = data || {};
      if (_objectUtils.default.isDate(data.expires)) {
        expires = ";expires=" + data.expires.toUTCString();
      } else if (_objectUtils.default.isNumeric(data.expires)) {
        d.setTime(d.getTime() + data.expires * 1000);
        expires = ";expires=" + d.toUTCString();
      } else {
        expires = "";
      }
      if (data.path) {
        path = ";path=" + data.path;
      } else {
        path = "";
      }
      if (data.domain) {
        domain = ";domain=" + data.domain;
      } else {
        domain = "";
      }
      if (data.secure) {
        secure = ";secure";
      } else {
        secure = "";
      }
      document.cookie = name + "=" + value + expires + path + domain + secure;
      this._all = undefined;
    }
  }, {
    key: "remove",
    value: function remove(name) {
      this.set(name, '', {
        expires: -31536000
      });
    }
  }, {
    key: "removeAll",
    value: function removeAll() {
      var cookies = this.getAll();
      for (var key in cookies) {
        this.remove(key);
      }
    }
  }]);
  return CookieUtils;
}();
var _default = exports.default = new CookieUtils();