"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var DocumentReady = /*#__PURE__*/function () {
  function DocumentReady() {
    _classCallCheck(this, DocumentReady);
    this._readyList = [];
    this._readyFired = false;
    this._readyEventHandlersInstalled = false;
    this._onReady = this._onReady.bind(this);
    this._onReadyStateChange = this._onReadyStateChange.bind(this);
  }

  // call this when the document is ready
  // this function protects itself against being called more than once
  _createClass(DocumentReady, [{
    key: "_onReady",
    value: function _onReady() {
      if (!this._readyFired) {
        // this must be set to true before we start calling callbacks
        this._readyFired = true;
        for (var i = 0; i < this._readyList.length; i++) {
          // if a callback here happens to add new ready handlers,
          // the docReady() function will see that it already fired
          // and will schedule the callback to run right after
          // this event loop finishes so all handlers will still execute
          // in order and no new ones will be added to the readyList
          // while we are processing the list
          this._readyList[i].fn(this._readyList[i].ctx);
        }
        // allow any closures held by these functions to free
        this._readyList = [];
        if (this._readyEventHandlersInstalled) {
          if (document.removeEventListener) {
            document.removeEventListener("DOMContentLoaded", this._onReady);
            window.removeEventListener("load", this._onReady);
          } else {
            // must be IE
            document.detachEvent("onreadystatechange", this._onReadyStateChange);
            window.detachEvent("onload", this._onReady);
          }
          this._readyEventHandlersInstalled = false;
        }
      }
    }
  }, {
    key: "_onReadyStateChange",
    value: function _onReadyStateChange() {
      if (document.readyState === "complete") {
        this._onReady();
      }
    }

    // This is the one public interface
    // docReady(fn, context);
    // the context argument is optional - if present, it will be passed
    // as an argument to the callback
  }, {
    key: "ready",
    value: function ready(callback, context) {
      // if ready has already fired, then just schedule the callback
      // to fire asynchronously, but right away
      if (this._readyFired) {
        setTimeout(function () {
          callback(context);
        }, 1);
        return;
      } else {
        // add the function and context to the list
        this._readyList.push({
          fn: callback,
          ctx: context
        });
      }
      // if document already ready to go, schedule the ready function to run
      if (document.readyState === "complete") {
        setTimeout(this._onReady, 1);
      } else if (!this._readyEventHandlersInstalled) {
        // otherwise if we don't have event handlers installed, install them
        if (document.addEventListener) {
          // first choice is DOMContentLoaded event
          document.addEventListener("DOMContentLoaded", this._onReady);
          // backup is window load event
          window.addEventListener("load", this._onReady);
        } else {
          // must be IE
          document.attachEvent("onreadystatechange", this._onReadyStateChange);
          window.attachEvent("onload", this._onReady);
        }
        this._readyEventHandlersInstalled = true;
      }
    }
  }]);
  return DocumentReady;
}();
var _default = exports.default = new DocumentReady();