"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var utils = {};
var _default = exports.default = utils;
var class2type = {};
var toString = class2type.toString;
var hasOwn = class2type.hasOwnProperty;

// Slolen from jQuery
utils.extend = function () {
  var options,
    name,
    src,
    copy,
    copyIsArray,
    clone,
    target = arguments[0] || {},
    i = 1,
    length = arguments.length,
    deep = false;

  // Handle a deep copy situation
  if (typeof target === "boolean") {
    deep = target;

    // Skip the boolean and the target
    target = arguments[i] || {};
    i++;
  }

  // Handle case when target is a string or something (possible in deep copy)
  if (_typeof(target) !== "object" && !utils.isFunction(target)) {
    target = {};
  }

  // Extend utils itself if only one argument is passed
  if (i === length) {
    target = utils;
    i--;
  }
  for (; i < length; i++) {
    // Only deal with non-null/undefined values
    if ((options = arguments[i]) !== null) {
      // Extend the base object
      for (name in options) {
        src = target[name];
        copy = options[name];

        // Prevent never-ending loop
        if (target === copy) {
          continue;
        }

        // Recurse if we're merging plain objects or arrays
        if (deep && copy && (utils.isPlainObject(copy) || (copyIsArray = utils.isArray(copy)))) {
          if (copyIsArray) {
            copyIsArray = false;
            clone = src && utils.isArray(src) ? src : [];
          } else {
            clone = src && utils.isPlainObject(src) ? src : {};
          }

          // Never move original objects, clone them
          target[name] = utils.extend(deep, clone, copy);

          // Don't bring in undefined values
        } else if (copy !== undefined) {
          target[name] = copy;
        }
      }
    }
  }

  // Return the modified object
  return target;
};
utils.isArrayLike = function (obj) {
  // Support: iOS 8.2 (not reproducible in simulator)
  // `in` check used to prevent JIT error (gh-2145)
  // hasOwn isn't used here due to false negatives
  // regarding Nodelist length in IE
  var length = "length" in obj && obj.length,
    type = utils.type(obj);
  if (type === "function" || utils.isWindow(obj)) {
    return false;
  }
  if (obj.nodeType === 1 && length) {
    return true;
  }
  return type === "array" || length === 0 || typeof length === "number" && length > 0 && length - 1 in obj;
};
utils.type = function (obj) {
  if (obj === null) {
    return obj + "";
  }
  // Support: Android<4.0, iOS<6 (functionish RegExp)
  return _typeof(obj) === "object" || typeof obj === "function" ? class2type[toString.call(obj)] || "object" : _typeof(obj);
};
utils.isFunction = function (obj) {
  return utils.type(obj) === "function";
};
utils.isDate = function (obj) {
  return utils.isPlainObject(obj) && utils.isFunction(obj.toUTCString);
};
utils.isArray = Array.isArray;
utils.isWindow = function (obj) {
  return obj !== null && obj === obj.window;
};
utils.isNumeric = function (obj) {
  // parseFloat NaNs numeric-cast false positives (null|true|false|"")
  // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
  // subtraction forces infinities to NaN
  // adding 1 corrects loss of precision from parseFloat (#15100)
  return !utils.isArray(obj) && obj - parseFloat(obj) + 1 >= 0;
};
utils.isString = function (obj) {
  return typeof obj === 'string' || obj instanceof String;
};
utils.isPlainObject = function (obj) {
  // Not plain objects:
  // - Any object or value whose internal [[Class]] property is not "[object Object]"
  // - DOM nodes
  // - window
  if (utils.type(obj) !== "object" || obj.nodeType || utils.isWindow(obj)) {
    return false;
  }
  if (obj.constructor && !hasOwn.call(obj.constructor.prototype, "isPrototypeOf")) {
    return false;
  }

  // If the function hasn't returned already, we're confident that
  // |obj| is a plain object, created by {} or constructed with new Object
  return true;
};
utils.isEmptyObject = function (obj) {
  var name;
  for (name in obj) {
    return false;
  }
  return true;
};

// args is for internal usage only
utils.each = function (obj, callback, args) {
  var value,
    i = 0,
    length = obj.length,
    isArray = utils.isArrayLike(obj);
  if (args) {
    if (isArray) {
      for (; i < length; i++) {
        value = callback.apply(obj[i], args);
        if (value === false) {
          break;
        }
      }
    } else {
      for (i in obj) {
        value = callback.apply(obj[i], args);
        if (value === false) {
          break;
        }
      }
    }

    // A special, fast, case for the most common use of each
  } else {
    if (isArray) {
      for (; i < length; i++) {
        value = callback.call(obj[i], i, obj[i]);
        if (value === false) {
          break;
        }
      }
    } else {
      for (i in obj) {
        value = callback.call(obj[i], i, obj[i]);
        if (value === false) {
          break;
        }
      }
    }
  }
  return obj;
};
utils.each("Boolean Number String Function Array Date RegExp Object Error".split(" "), function (i, name) {
  class2type["[object " + name + "]"] = name.toLowerCase();
});