"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var string_utils = {};
var _default = exports.default = string_utils;
string_utils.replaceAll = function (string, replace_what, replace_with) {
  return string.split(replace_what).join(replace_with);
};
string_utils.toCamelCase = function (string, sep, join, pascal) {
  pascal = pascal || false;
  var first = !pascal;
  return string.split(sep).map(function (i) {
    var ret = first ? i.toLowerCase() : i[0].toUpperCase() + i.substring(1).toLowerCase();
    first = false;
    return ret;
  }).join(join);
};
string_utils.fromCamelCase = function (str, sep) {
  if (sep === undefined) sep = ' ';
  return str.replace(/([A-Z])/g, function (g, p, offset) {
    return "".concat(offset > 0 ? sep : '').concat(g[0].toLowerCase());
  });
};
string_utils.format = function (format) {
  var args = arguments;
  var formatted = format.replace(/{(\d+)}/g, function (match, number) {
    var index = parseInt(number) + 1;
    var ret = typeof args[index] != 'undefined' ? args[index] : match;
    return ret;
  });
  return formatted;
};