"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _JssParser = _interopRequireDefault(require("../JssParser"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
var StyleUtils = /*#__PURE__*/function () {
  function StyleUtils() {
    _classCallCheck(this, StyleUtils);
  }
  _createClass(StyleUtils, [{
    key: "createStyleElement",
    value: function createStyleElement(document, id) {
      // Create the <style> tag
      var style = document.createElement('style');
      style.id = id;
      return style;
    }
  }, {
    key: "removeStylesheet",
    value: function removeStylesheet(document, id) {
      var style = document.getElementById(id);
      if (style && style.tagName.toLowerCase() == 'style') {
        style.parentNode.removeChild(style);
        return true;
      }
      return false;
    }

    // links is an array of ids for the link elements
  }, {
    key: "removeStylesheetLinks",
    value: function removeStylesheetLinks(document, links) {
      for (var i = 0, max = links.length; i < max; i++) {
        var link = document.getElementById(links[i]);
        if (link && link.tagName.toLowerCase() == 'link') {
          link.parentNode.removeChild(link);
        }
      }
    }

    // spec is {url:<url to css>, id:<id for link element>, [media:<css link media attr>]}
  }, {
    key: "addStylesheetLink",
    value: function addStylesheetLink(document, spec) {
      var head = document.getElementsByTagName('head')[0];
      if (head == undefined) return false;
      var link = document.createElement('link');
      link.id = spec.id;
      link.rel = 'stylesheet';
      link.type = 'text/css';
      link.href = spec.url;
      if (spec.media) link.media = spec.media;
      head.appendChild(link);
      return true;
    }

    /*
     * styles is in the form of json and is parsed with the style utils.
     * see 
     */
  }, {
    key: "createStylesheet",
    value: function createStylesheet(document, id, jss) {
      var style = this.createStyleElement(document, id);
      var css = this._getJssUtils().toCSS(jss);
      if (style.styleSheet) style.styleSheet.cssText = css; // Support for IE
      else style.appendChild(document.createTextNode(css)); // Support for the rest

      return style;
    }
  }, {
    key: "_getJssUtils",
    value: function _getJssUtils() {
      if (this._jssutils == undefined) {
        this._jssUtils = new _JssParser.default();
      }
      return this._jssUtils;
    }
  }]);
  return StyleUtils;
}();
var _default = exports.default = new StyleUtils();