"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var utils = {};
var _default = exports.default = utils;
var videoEvents = ['loadstart', 'progress', 'suspend', 'abort', 'error', 'emptied', 'stalled', 'loadedmetadata', 'loadeddata', 'canplay', 'canplaythrough', 'playing',
// fake event
'waiting', 'seeking', 'seeked', 'ended',
// 'durationchange',
'timeupdate', 'play',
// fake event
'pause',
// fake event
// 'ratechange',
// 'resize',
// 'volumechange',
'webkitbeginfullscreen', 'webkitendfullscreen'];
utils.addDebugEvents = function (video) {
  videoEvents.forEach(function (e) {
    video.addEventListener(e, function () {
      /* eslint no-console:0 */
      console.info('@', e);
    });
  });
};
var formatTimeNumber = function formatTimeNumber(num, leadingZero) {
  if (leadingZero && num < 10) return "0" + num;else return "" + num;
};
utils.getVideoTimeString = function (secs) {
  var hours = Math.floor(secs / 3600);
  var minutes = Math.floor((secs - hours * 3600) / 60);
  var seconds = Math.floor(secs - hours * 3600 - minutes * 60);
  var time = (hours > 0 ? formatTimeNumber(hours, false) + ":" : "") + formatTimeNumber(minutes, true) + ":" + formatTimeNumber(seconds, true);
  return time;
};