import cookieUtils from '../../src/utils/cookieUtils.js';

/* eslint no-undef: "off" */

describe('Cookie Utils setCookie', function () {
  it('sets a cookie and retreives it.', function () {
    cookieUtils.set('TestCookie', 'this is test cookie one');
    expect(cookieUtils.get('TestCookie')).toBe('this is test cookie one');
  });

  it('sets a cookie and removes it.', function () {
    cookieUtils.set('TestCookie', 'this is test cookie one');
    expect(cookieUtils.get('TestCookie')).toBe('this is test cookie one');
    cookieUtils.remove('TestCookie');
    expect(cookieUtils.get('TestCookie')).toBe(undefined);
  });

  it('sets 3 cookies and and calls cookieUtils.removeAll.', function () {
    cookieUtils.set('TestCookie1', 'this is test cookie one');
    expect(cookieUtils.get('TestCookie1')).toBe('this is test cookie one');
    cookieUtils.set('TestCookie2', 'this is test cookie two');
    expect(cookieUtils.get('TestCookie2')).toBe('this is test cookie two');
    cookieUtils.set('TestCookie3', 'this is test cookie three');
    expect(cookieUtils.get('TestCookie3')).toBe('this is test cookie three');

    cookieUtils.removeAll();
    expect(Object.keys(cookieUtils.getAll()).length).toBe(0);
  });

  it('sets a json cookie and retreives it.', function () {
    var phrase = 'hello world';
    var object = { phrase: phrase, count: phrase.length };

    cookieUtils.set('TestCookie', JSON.stringify(object));
    expect(cookieUtils.getObject('TestCookie')).toEqual(object);
  });
});
