import stringUtils from '../../src/utils/stringUtils.js';

/* eslint no-undef: "off" */

describe('String Utils toCamelCase', function () {
  it('converts to cammel case', function () {
    expect(stringUtils.toCamelCase('this_is_a_test', '_', '')).toBe(
      'thisIsATest'
    );
  });
});

describe('String Utils replaceAll', function () {
  it("replaces 'this' with 'that' in 'this is a test'", function () {
    expect(stringUtils.replaceAll('this is a test', 'this', 'that')).toBe(
      'that is a test'
    );
  });

  it("replaces 'this' with 'that' in 'a test is this'", function () {
    expect(stringUtils.replaceAll('a test is this', 'this', 'that')).toBe(
      'a test is that'
    );
  });

  it("replaces nothing in 'a test is this'", function () {
    expect(stringUtils.replaceAll('a test is this', 'stop', 'that')).toBe(
      'a test is this'
    );
  });
});

describe('String Utils fromCamelCase', function () {
  it('converts from camelCase', function () {
    expect(stringUtils.fromCamelCase('helloWorld', '-')).toBe('hello-world');
    expect(stringUtils.fromCamelCase('helloAWorld', '-')).toBe('hello-a-world');
    expect(stringUtils.fromCamelCase('HelloWorld', '-')).toBe('hello-world');
    expect(stringUtils.fromCamelCase('helloAwesomeWorld', '-')).toBe(
      'hello-awesome-world'
    );
  });
});
