import $ from 'jquery';
import stringUtils from './utils/stringUtils';
import objectUtils from './utils/objectUtils';
import startsWith from 'babel-runtime/core-js/string/starts-with';

function add(container, root, selector, name) {
  var itemName = stringUtils.toCamelCase(name, '-', '');
  var $itemName = '$' + itemName;
  var $element;

  if (root && root.is(selector)) {
    $element = root;
  } else {
    $element = root ? root.find(selector) : $(selector);
  }

  //console.log("Setting: " + $itemName);
  container[$itemName] = $element;
  if ($element.length > 0) {
    //console.log("Setting: " + itemName);
    container[itemName] = $element.get(0);
  }
}

function nameFromSelector(selector) {
  var name;
  if (startsWith(selector, '#') || startsWith(selector, '.')) {
    name = selector.substring(1, selector.length);
  } else {
    name = selector;
  }
  return name;
}

/*
 * An object that contains the element and jquery items for each item in items.
 * items contains the jqery selector and name. It can be an array of strings
 * where the name is made by removing either the '.' or '#' form the string.
 * ["panel", "#list"]
 *
 * If the array item is an array the first item is the name and the second
 * is the selector.
 * [["panel", "#panel"], ["list", "#item-list"]]
 *
 * If the array item is an object, the name and selector is taken from
 * item.name and item.selector.
 * [{name:"panel", selector:"#panel"}, {name:"list", selector:"#item-list"}]
 *
 * The jqery object name is name with $ prepeneded to it. Names with '-'
 * get the '-' removed and the alpha character following '-' is set to upper case
 * the-name becomes theName and the jquery object become $theName.
 */
export default class ElementSet {
  constructor(root, items) {
    var max = items.length;
    for (var i = 0; i < max; i++) {
      var item = items[i];
      var selector;
      var name;
      if (typeof item === 'string') {
        selector = item;
        name = nameFromSelector(selector);
      } else if (objectUtils.isPlainObject(item)) {
        selector = item.selector;
        name = item.name;
      } else if (objectUtils.isArrayLike(item)) {
        if (item.length > 1) {
          selector = item[0];
          name = item[1];
        } else if (item.length > 0) {
          selector = item[0];
          name = nameFromSelector(selector);
        }
      }

      if (typeof name !== 'undefined' && typeof selector !== 'undefined') {
        add(this, root, selector, name);
      }
    }
  }
}
