/*
 * Provides functionality for associating names with lists of functions
 * and functionality to execute that list of methods via notify. This
 * is not tied into the system events.
 */
export default class EventDispatcher {
  constructor() {
    this._handlers = {};
  }

  on(name, func, context) {
    let array = this._handlers[name];
    if (array === undefined) {
      array = [];
      this._handlers[name] = array;
    }
    array.push({ func: func, context: context });
  }

  off(name, func, context) {
    let array = this._handlers[name];
    if (array) {
      let index = this._find(array, func, context);
      if (index > -1) {
        array.splice(index, 1);
      }
      if (array.length == 0) {
        delete this._handlers[name];
      }
    }
  }

  dispatch(name, e, context) {
    let array = this._handlers[name];
    let handled = false;
    if (array) {
      for (var n = 0, max = array.length; n < max; n++) {
        var item = array[n];
        var ctx = context || item.context;
        if (ctx) {
          handled = item.func.call(ctx, e) || handled;
        } else {
          handled = item.func(e) || handled;
        }
      }
    }
    return handled;
  }

  _find(array, func, context) {
    for (var n = 0, max = array ? array.length : 0; n < max; n++) {
      var item = array[n];
      if (
        item.func == func &&
        (context == undefined || item.context === context)
      ) {
        return n;
      }
    }

    return -1;
  }
}
