import objectUtils from './objectUtils';

class CookieUtils {
  constructor() {}

  getAll() {
    if (typeof this._all === 'undefined') {
      var cookies = document.cookie.split(';');
      var ret = {};
      for (var i = 0; i < cookies.length; i++) {
        var cookie = cookies[i].split('=');
        var key = cookie && cookie.length > 0 ? cookie[0].trim() : undefined;
        var value = cookie && cookie.length > 1 ? cookie[1] : undefined;
        if (key && typeof value !== 'undefined') {
          ret[key] = value;
        }
      }
      this._all = ret;
    }
    return this._all;
  }

  has(name) {
    return typeof this.getAll()[name] !== 'undefined';
  }

  get(name) {
    return this.getAll()[name];
  }

  /*
   * gets a cookie and parses the json.
   * name - the name of the cookie.
   */
  getObject(name) {
    var value = this.get(name);
    var ret = undefined;

    if (typeof value !== 'undefined') {
      try {
        ret = JSON.parse(value);
      } catch (e) {
        console.warn(e);
      }
    }

    return ret;
  }

  /*
   * name - cookie name.
   * value - cookie value.
   * data {
   *    expires (optional) - expiration in seconds from now or Date of expire.
   *    path (optional) - path for the cookie
   *    domain
   *    secure
   * }
   */
  set(name, value, data) {
    var d = new Date();
    var expires;
    var path;
    var secure;
    var domain;

    data = data || {};

    if (objectUtils.isDate(data.expires)) {
      expires = ';expires=' + data.expires.toUTCString();
    } else if (objectUtils.isNumeric(data.expires)) {
      d.setTime(d.getTime() + data.expires * 1000);
      expires = ';expires=' + d.toUTCString();
    } else {
      expires = '';
    }

    if (data.path) {
      path = ';path=' + data.path;
    } else {
      path = '';
    }

    if (data.domain) {
      domain = ';domain=' + data.domain;
    } else {
      domain = '';
    }

    if (data.secure) {
      secure = ';secure';
    } else {
      secure = '';
    }

    document.cookie = name + '=' + value + expires + path + domain + secure;
    this._all = undefined;
  }

  remove(name) {
    this.set(name, '', { expires: -31536000 });
  }

  removeAll() {
    var cookies = this.getAll();
    for (var key in cookies) {
      this.remove(key);
    }
  }
}

export default new CookieUtils();
