class ElementUtils {
  innerWindowSize() {
    return {
      width:
        window.innerWidth ||
        document.documentElement.clientWidth ||
        document.body.clientWidth,
      height:
        window.innerHeight ||
        document.documentElement.clientHeight ||
        document.body.clientHeight,
    };
  }

  logWindowSize(text) {
    var size = this.innerWindowSize();
    console.warn(text + '(' + size.width + ', ' + size.height + ')');
  }

  isIFrame() {
    return window.self !== window.top;
  }

  hasClass(element, className) {
    return (
      (' ' + element.className + ' ')
        .replace(/[\n\t\r]/g, ' ')
        .indexOf(className) > -1
    );
  }

  hasChild(parent, element) {
    if (parent === element) return true;
    for (
      var n = 0,
        max =
          parent.childNodes && parent.childNodes.length
            ? parent.childNodes.length
            : 0;
      n < max;
      n++
    ) {
      if (this.hasChild(parent.childNodes[n], element)) {
        return true;
      }
    }

    return false;
  }
}

export default new ElementUtils();
