import JssUtils from '../JssParser';

class StyleUtils {
  constructor() {}
  createStyleElement(document, id) {
    // Create the <style> tag
    var style = document.createElement('style');
    style.id = id;
    return style;
  }

  removeStylesheet(document, id) {
    var style = document.getElementById(id);
    if (style && style.tagName.toLowerCase() == 'style') {
      style.parentNode.removeChild(style);
      return true;
    }
    return false;
  }

  // links is an array of ids for the link elements
  removeStylesheetLinks(document, links) {
    for (var i = 0, max = links.length; i < max; i++) {
      var link = document.getElementById(links[i]);
      if (link && link.tagName.toLowerCase() == 'link') {
        link.parentNode.removeChild(link);
      }
    }
  }

  // spec is {url:<url to css>, id:<id for link element>, [media:<css link media attr>]}
  addStylesheetLink(document, spec) {
    var head = document.getElementsByTagName('head')[0];
    if (head == undefined) return false;
    var link = document.createElement('link');
    link.id = spec.id;
    link.rel = 'stylesheet';
    link.type = 'text/css';
    link.href = spec.url;
    if (spec.media) link.media = spec.media;
    head.appendChild(link);
    return true;
  }

  /*
   * styles is in the form of json and is parsed with the style utils.
   * see
   */
  createStylesheet(document, id, jss) {
    var style = this.createStyleElement(document, id);
    var css = this._getJssUtils().toCSS(jss);

    if (style.styleSheet)
      style.styleSheet.cssText = css; // Support for IE
    else style.appendChild(document.createTextNode(css)); // Support for the rest

    return style;
  }

  _getJssUtils() {
    if (this._jssutils == undefined) {
      this._jssUtils = new JssUtils();
    }
    return this._jssUtils;
  }
}

export default new StyleUtils();
