var utils = {};

export default utils;

var qs = null;

function getQs(a) {
  if (a === '') return {};
  var b = {};
  for (var i = 0; i < a.length; ++i) {
    var p = a[i].split('=', 2);
    if (p.length == 1) b[p[0]] = '';
    else b[p[0]] = decodeURIComponent(p[1].replace(/\+/g, ' '));
  }

  return b;
}

utils.querySettings = function () {
  if (qs === null) {
    qs = getQs(window.location.search.substr(1).split('&'));
  }

  return qs;
};

utils.protocol = function () {
  return window.location.protocol;
};

utils.path = function () {
  return window.location.pathname;
};

utils.objectToQueryString = function (obj, prefix) {
  var str = [],
    p;
  for (p in obj) {
    if (obj.hasOwnProperty(p)) {
      var k = prefix ? prefix + '[' + p + ']' : p,
        v = obj[p];
      str.push(
        v !== null && typeof v === 'object'
          ? utils.objectToQueryString(v, k)
          : encodeURIComponent(k) + '=' + encodeURIComponent(v)
      );
    }
  }
  return str.join('&');
};
